/*
 * Decompiled with CFR 0.152.
 */
package jclass.bwt;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import jclass.bwt.BWTUtil;
import jclass.bwt.ButtonConverter;
import jclass.bwt.JCActionEvent;
import jclass.bwt.JCActionListener;
import jclass.bwt.JCButtonEvent;
import jclass.bwt.JCButtonListener;
import jclass.bwt.JCComponent;
import jclass.bwt.JCLabel;
import jclass.util.JCString;
import jclass.util.JCVector;

public class JCButton
extends JCLabel {
    Object arm_label;
    boolean armed = false;
    protected int old_shadowtype;
    String actionCommand;
    boolean inside_button = false;
    boolean is_action_button = false;
    private static final boolean TRACE = false;
    protected JCVector actionListeners = new JCVector(0);
    protected JCVector buttonListeners = new JCVector(0);
    private static final String base = "button";
    private static int nameCounter;
    protected int arm_offset = 1;

    public JCButton() {
        this(null, null, null);
    }

    public JCButton(Object object) {
        this(object, null, null);
    }

    public JCButton(String string, Image image, int n) {
        this(new JCString(string, image, n), null, null);
        this.setName(string);
    }

    public JCButton(String string, String string2, Applet applet, int n) {
        this(null, null, null);
        this.setLabel(new JCString(string, JCComponent.conv.toImage(applet, string2), n));
        this.insets = new Insets(2, 5, 2, 5);
    }

    public JCButton(Object object, Applet applet, String string) {
        super(object, applet, string);
        if (string == null) {
            this.setName(base + nameCounter++);
        }
        this.border_style = 9;
        this.traversable = true;
        this.highlight = 1;
        this.border = 2;
        this.insets = object == null || object instanceof String ? new Insets(0, 5, 0, 5) : new Insets(2, 5, 2, 5);
        if (this.getClass().getName().equals("jclass.bwt.JCButton")) {
            this.getParameters(applet);
        }
        this.enableEvents(32L);
    }

    protected void getParameters() {
        super.getParameters();
        ButtonConverter.getParams(this);
    }

    public boolean getIsActionButton() {
        return this.is_action_button;
    }

    public void setIsActionButton(boolean bl) {
        if (bl != this.is_action_button) {
            this.is_action_button = bl;
            this.repaint();
        }
    }

    public Object getArmLabel() {
        return this.arm_label;
    }

    public void setArmLabel(Object object) {
        this.arm_label = object;
        if (this.armed) {
            this.layout();
            this.repaint();
        }
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public String getActionCommand() {
        if (this.actionCommand == null) {
            return String.valueOf(this.label);
        }
        return this.actionCommand;
    }

    public void addActionListener(JCActionListener jCActionListener) {
        this.actionListeners.addUnique(jCActionListener);
    }

    public void removeActionListener(JCActionListener jCActionListener) {
        this.actionListeners.removeElement(jCActionListener);
    }

    public void addButtonListener(JCButtonListener jCButtonListener) {
        this.buttonListeners.addUnique(jCButtonListener);
    }

    public void removeButtonListener(JCButtonListener jCButtonListener) {
        this.buttonListeners.removeElement(jCButtonListener);
    }

    public void armAction(Event event) {
        this.old_shadowtype = this.border_style;
        this.border_style = 3;
        this.armed = true;
        JCButtonEvent jCButtonEvent = this.buttonListeners.size() > 0 ? new JCButtonEvent(event) : null;
        int n = 0;
        while (n < this.buttonListeners.size()) {
            ((JCButtonListener)this.buttonListeners.elementAt(n)).buttonArmBegin(jCButtonEvent);
            ++n;
        }
        Dimension dimension = this.size();
        this.paintImmediately(0, 0, dimension.width, dimension.height);
        this.border_style = this.old_shadowtype;
        int n2 = 0;
        while (n2 < this.buttonListeners.size()) {
            ((JCButtonListener)this.buttonListeners.elementAt(n2)).buttonArmEnd(jCButtonEvent);
            ++n2;
        }
    }

    public void disarmAction(Event event) {
        JCButtonEvent jCButtonEvent = this.buttonListeners.size() > 0 ? new JCButtonEvent(event) : null;
        int n = 0;
        while (n < this.buttonListeners.size()) {
            ((JCButtonListener)this.buttonListeners.elementAt(n)).buttonDisarmBegin(jCButtonEvent);
            ++n;
        }
        if (this.armed && this.arm_label != null) {
            this.layout(this.label);
        }
        this.armed = false;
        this.border_style = this.old_shadowtype;
        Dimension dimension = this.size();
        this.paintImmediately(0, 0, dimension.width, dimension.height);
        int n2 = 0;
        while (n2 < this.buttonListeners.size()) {
            ((JCButtonListener)this.buttonListeners.elementAt(n2)).buttonDisarmEnd(jCButtonEvent);
            ++n2;
        }
    }

    public void clickAction(Event event) {
        String string = this.getActionCommand();
        if (event == null) {
            event = new Event(this, 0, string);
        }
        JCActionEvent jCActionEvent = new JCActionEvent(this, event.id, string, event.modifiers);
        int n = 0;
        while (n < this.actionListeners.size()) {
            ((JCActionListener)this.actionListeners.elementAt(n)).actionPerformed(jCActionEvent);
            ++n;
        }
    }

    public synchronized void layout() {
        super.layout();
        if (this.getPeer() == null) {
            return;
        }
        if (BWTUtil.isRight(this.alignment)) {
            this.label_rect.x -= this.arm_offset;
        } else if (BWTUtil.isCenter(this.alignment)) {
            this.label_rect.x -= this.arm_offset / 2;
        }
        if (BWTUtil.isMiddle(this.alignment)) {
            this.label_rect.y -= this.arm_offset / 2;
            return;
        }
        if (BWTUtil.isBottom(this.alignment)) {
            this.label_rect.y -= this.arm_offset;
        }
    }

    protected void drawValue(Graphics graphics, Object object) {
        if (this.armed && this.arm_label != null) {
            this.layout(this.arm_label);
            graphics.translate(this.arm_offset, this.arm_offset);
            super.drawValue(graphics, this.arm_label);
        } else {
            if (this.armed) {
                graphics.translate(this.arm_offset, this.arm_offset);
            }
            super.drawValue(graphics, object);
        }
        if (this.armed) {
            graphics.translate(-this.arm_offset, -this.arm_offset);
        }
    }

    protected void drawHighlight(Graphics graphics, boolean bl) {
        Color color;
        super.drawHighlight(graphics, bl);
        int n = 4;
        int n2 = 4;
        int n3 = this.size().width;
        int n4 = this.size().height;
        Color color2 = color = bl ? this.highlight_color : this.getBackground();
        if (color == null) {
            color = this.getForeground();
        }
        graphics.setColor(color);
        if (bl) {
            BWTUtil.drawDashedRect(graphics, n, n2, n3 - 2 * n - 1, n4 - 2 * n2 - 1);
        } else {
            graphics.drawRect(n, n2, n3 - 2 * n - 1, n4 - 2 * n2 - 1);
        }
        if (this.is_action_button && this.highlight > 0) {
            n = 0;
            n2 = 0;
            n3 = this.size().width;
            n4 = this.size().height;
            graphics.setColor(this.getHighlightColor() != null ? this.getHighlightColor() : Color.black);
            int n5 = 0;
            while (n5 < this.highlight) {
                graphics.drawRect(n, n2, n3 - 1, n4 - 1);
                ++n5;
                ++n;
                ++n2;
                n3 -= 2;
                n4 -= 2;
            }
        }
    }

    public boolean isArmed() {
        return this.armed;
    }

    public boolean mouseEnter(Event event, int n, int n2) {
        this.inside_button = true;
        if (!this.isEnabled()) {
            return false;
        }
        if (!this.armed) {
            return false;
        }
        this.armAction(event);
        return true;
    }

    public boolean mouseExit(Event event, int n, int n2) {
        this.inside_button = false;
        if (!this.armed) {
            return false;
        }
        this.disarmAction(event);
        this.armed = true;
        return true;
    }

    public boolean mouseMove(Event event, int n, int n2) {
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (this.inside(n, n2) && !this.inside_button) {
            this.mouseEnter(event, n, n2);
        } else if (!this.inside(n, n2) && this.inside_button) {
            this.mouseExit(event, n, n2);
        }
        return true;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (BWTUtil.getMouseButton(event) != 1) {
            return false;
        }
        if (this.armed) {
            return true;
        }
        if (!this.inside(n, n2)) {
            return false;
        }
        if (!this.isEnabled()) {
            return false;
        }
        super.mouseDown(event, n, n2);
        this.armAction(event);
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (BWTUtil.getMouseButton(event) != 1) {
            return false;
        }
        if (this.inside(n, n2) && this.armed) {
            this.disarmAction(event);
            this.clickAction(event);
        } else if (this.armed) {
            this.armed = false;
            this.repaint();
        }
        return true;
    }

    public boolean keyDown(Event event, int n) {
        super.keyDown(event, n);
        if (event.key == 10 || (char)event.key == ' ') {
            this.armAction(event);
            this.getToolkit().sync();
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {}
            this.disarmAction(event);
            this.clickAction(event);
            this.getToolkit().sync();
            return true;
        }
        return false;
    }

    protected int preferredWidth() {
        int n = Math.max(this.label_width + this.arm_offset, BWTUtil.getWidth(this.arm_label, this) + this.arm_offset);
        return Math.max(20, n);
    }

    protected int preferredHeight() {
        int n = Math.max(this.label_height + this.arm_offset, BWTUtil.getHeight(this.arm_label, this) + this.arm_offset);
        return Math.max(20, n);
    }
}

